<?php
session_start();
// Check access
if (!isset($_SESSION['access_key'])) {
    http_response_code(401);
    exit;
}
header('Content-Type: application/json');

if (!isset($_GET['profile'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing profile']);
    exit;
}

$xml = simplexml_load_file(__DIR__ . '/../profiles.xml');
$platforms = [];
foreach ($xml->profile as $p) {
    if ((string)$p['name'] === $_GET['profile']) {
        foreach ($p->platform as $plat) {
            $attrs = $plat->attributes();
            $platforms[] = [
                'name'   => (string)$attrs['name'],  
                'number' => (string)$attrs['number'],
                'link'   => isset($attrs['link']) ? (string)$attrs['link'] : ''
            ];
        }
        break;
    }
}

echo json_encode($platforms);