<?php
session_start();

// --- Security: require access key ---
$keysPath = __DIR__ . '/../keys.xml';
$keysXml  = simplexml_load_file($keysPath);
$valid    = [];
foreach ($keysXml->key as $k) {
    $valid[] = trim((string)$k);
}

// If an access_key is provided via GET, validate and store in session
if (isset($_GET['access_key'])) {
    $provided = trim($_GET['access_key']);
    if (!in_array($provided, $valid, true)) {
        header('HTTP/1.1 401 Unauthorized');
        echo 'Invalid access key.';
        exit;
    }
    $_SESSION['access_key'] = $provided;
}

// If no valid session key, block access
if (!isset($_SESSION['access_key'])) {
    header('HTTP/1.1 401 Unauthorized');
    echo 'Access key required.';
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <link rel="stylesheet" href="../assets/css/style.css">
  <title>Contact Number Guide</title>
</head>
<body>
  <div class="chat-container">
    <div id="messages"></div>
    <div id="choices"></div>
  </div>

  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="../assets/js/app.js"></script>
</body>
</html>