<?php
// Enable error reporting for debugging
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Paths for feedback files
define('LOG_FILE', __DIR__ . '/feedback_log.txt');
define('CACHE_FILE', __DIR__ . '/feedback_cache.txt');

// Retrieve method
decorated: $_SERVER['REQUEST_METHOD'];
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $rating = isset($_GET['rating']) ? intval($_GET['rating']) : 0;
    $ticket = isset($_GET['ticket']) ? htmlspecialchars($_GET['ticket']) : '';
    $force  = isset($_GET['force']) && $_GET['force'] === 'true';

    // Prevent duplicate logs within a minute
    $logHash       = md5($_SERVER['REMOTE_ADDR'] . $rating . $ticket . date('Y-m-d H:i'));
    $alreadyLogged = false;
    if (!$force && file_exists(CACHE_FILE)) {
        $cacheContents = file(CACHE_FILE, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
        if (in_array($logHash, $cacheContents, true)) {
            $alreadyLogged = true;
        }
    }

    // Log rating and send notification
    if ($rating >= 1 && $rating <= 5 && (!$alreadyLogged || $force)) {
        $timestamp = date('Y-m-d H:i:s');
        $entry     = sprintf("%s | Rating: %d%s\n", $timestamp, $rating, $ticket ? " | Ticket: $ticket" : '');
        file_put_contents(LOG_FILE, $entry, FILE_APPEND | LOCK_EX);

        // Load or fallback email function
        $sendEmailPath = __DIR__ . '/send_email.php';
        if (file_exists($sendEmailPath)) {
            require_once $sendEmailPath;
        }
        if (!function_exists('send_email')) {
            function send_email(array $to, string $subject, string $body, array $cc = []) {
                $headers  = "MIME-Version: 1.0\r\n";
                $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
                if (!empty($cc)) {
                    $headers .= "Cc: " . implode(',', $cc) . "\r\n";
                }
                return mail(implode(',', $to), $subject, $body, $headers);
            }
        }

        $toEmails = ['mgreen@techreadypro.com'];
        $ccEmails = ['mg@grndgtl.biz'];
        $subject  = "New Support Rating Received";
        $body     = sprintf(
            "<h3>New Feedback Rating</h3>\n" .
            "<p><strong>Rating:</strong> %d out of 5</p>\n" .
            "%s" .
            "<p><em>This was automatically submitted via feedback system.</em></p>",
            $rating,
            $ticket ? sprintf("<p><strong>Ticket ID:</strong> %s</p>\n", $ticket) : ''
        );
        send_email($toEmails, $subject, $body, $ccEmails);

        if (!$force) {
            file_put_contents(CACHE_FILE, $logHash . "\n", FILE_APPEND | LOCK_EX);
        }
    }

    // Invalid link
    if ($rating < 1 || $rating > 5) {
        http_response_code(400);
        echo '<h2>Invalid feedback link.</h2>';
        exit;
    }
}

if ($method === 'POST') {
    $rating  = isset($_POST['rating']) ? intval($_POST['rating']) : 0;
    $ticket  = isset($_POST['ticket']) ? htmlspecialchars($_POST['ticket']) : '';
    $comment = trim($_POST['comment'] ?? '');
    $timestamp = date('Y-m-d H:i:s');

    $comment = $comment ?: '(No additional comments)';
    $entry   = sprintf("%s | Comment%s | Rating: %d | %s\n",
                        $timestamp,
                        $ticket ? " for Ticket: $ticket" : '',
                        $rating,
                        $comment
    );
    file_put_contents(LOG_FILE, $entry, FILE_APPEND | LOCK_EX);

    echo '<!DOCTYPE html><html><head><meta charset="UTF-8"><title>Thank You</title></head><body>' .
         '<h2>Thank you for your feedback!</h2>' .
         '</body></html>';
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Support Feedback</title>
  <style>
    body { font-family:"Segoe UI",Tahoma,Geneva,Verdana,sans-serif; background:#f4f7f9; color:#333; padding:40px 20px; max-width:600px; margin:auto; border-radius:8px; box-shadow:0 0 10px rgba(0,0,0,0.1); }
    .logo-container { text-align:center; margin-bottom:20px; }
    .logo-container img { max-width:180px; height:auto; }
    h2 { text-align:center; color:#2c3e50; }
    p  { text-align:center; margin-bottom:25px; }
    textarea { width:100%; height:120px; padding:10px; font-size:14px; border-radius:4px; border:1px solid #ccc; resize:vertical; box-sizing:border-box; }
    button { background-color:#3498db; color:white; border:none; padding:12px 24px; border-radius:4px; font-size:16px; cursor:pointer; margin-top:15px; }
    button:hover { background-color:#2980b9; }
    form { margin-top:20px; }
  </style>
</head>
<body>
  <div class="logo-container">
    <img src="logo.png" alt="Company Logo">
  </div>
  <h2>Thanks for rating us <?php echo htmlspecialchars($rating ?? ''); ?> out of 5 stars!</h2>
  <p>If you'd like, you can leave additional comments below:</p>
  <form method="post" action="<?php echo basename(__FILE__); ?>">
    <input type="hidden" name="rating" value="<?php echo htmlspecialchars($rating ?? ''); ?>">
    <input type="hidden" name="ticket" value="<?php echo htmlspecialchars($ticket ?? ''); ?>">
    <textarea name="comment" placeholder="Your comments here..."></textarea><br>
    <button type="submit">Submit Feedback</button>
  </form>
</body>
</html>
