<?php
$logFile = 'feedback_log.txt';
$logs = [];

if (file_exists($logFile)) {
    $logs = array_reverse(file($logFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES));
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Feedback Ratings</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; max-width: 800px; margin: auto; background: #f9f9f9; }
        h1 { text-align: center; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        th, td { border: 1px solid #ccc; padding: 10px; }
        th { background: #eee; }
        tr:nth-child(even) { background-color: #f1f1f1; }
    </style>
</head>
<body>
    <h1>Customer Feedback Ratings</h1>

    <?php if (empty($logs)): ?>
        <p>No feedback has been recorded yet.</p>
    <?php else: ?>
        <table>
            <thead>
                <tr>
                    <th>Timestamp</th>
                    <th>Rating</th>
                    <th>Ticket</th>
                    <th>Comment</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($logs as $line): ?>
                    <?php
                    // Try to parse line (assumes format from feedback.php)
                    preg_match('/^(.*?) \| Rating: (\d)(?: \| Ticket: ([^\|]+))?(?: \| Comment(?: for Ticket: [^|]+)? \| (.*))?$/', $line, $matches);
                    ?>
                    <tr>
                        <td><?= htmlspecialchars($matches[1] ?? '—') ?></td>
                        <td><?= htmlspecialchars($matches[2] ?? '—') ?></td>
                        <td><?= htmlspecialchars($matches[3] ?? '') ?></td>
                        <td><?= nl2br(htmlspecialchars($matches[4] ?? '')) ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</body>
</html>
